unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
const
  InfoStr : array [1..11] of String =
    ('CompanyName', 'FileDescription', 'FileVersion',
     'InternalName', 'LegalCopyright',
     'LegalTradeMarks', 'OriginalFilename',
     'ProductName', 'ProductVersion',
     'Comments','Author');
  LabelStr : array [1..11] of String =
    ('Companhia', 'Descrio', 'Verso arquivo',
     'Nome interno', 'Copyright',
     'Marca registrada', 'Nome original',
     'Nome produto', 'Verso produto',
     'Comentrios', 'Autor');
var
  TamVer, i : Integer;
  Dummy : DWord;
  Tam : UINT;
  VerInfo : PChar;
  Valor : Pointer;
  Translation : Pointer;
  VerBegin : String;
begin
  ListBox1.Items.Clear;
  TamVer :=
     GetFileVersionInfoSize(PChar(ParamStr(0)),Dummy);
  if TamVer > 0 then begin
    GetMem(VerInfo,TamVer);
    ListBox1.Items.Add('Tamanho -'+IntToStr(TamVer));
    GetFileVersionInfo(PChar(ParamStr(0)),0,TamVer,VerInfo);
    VerQueryValue(VerInfo,'\\VarFileInfo\\Translation',Translation,Tam);
    VerBegin := '\\StringFileInfo\\'+
      IntToHex(LoWord(LongInt(Translation^)),4)+
      IntToHex(HiWord(LongInt(Translation^)),4)+'\\';
    for i:=1 to 11 do
      if VerQueryValue(VerInfo,
          PChar(VerBegin+InfoStr[i]),Valor,Tam) then
        if Tam > 0 then
          ListBox1.Items.Add(LabelStr[i]+' - '+String(PChar(Valor)));
    FreeMem(VerInfo,TamVer);
  end
  else
    ListBox1.Items.Add('No h informao de verso');
end;

end.
